VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmMulti 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "BASS multiple output example"
   ClientHeight    =   1515
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   4575
   Icon            =   "frmMulti.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1515
   ScaleWidth      =   4575
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame frameMulti 
      Caption         =   " device 1 "
      Height          =   735
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   0
      Width           =   4335
      Begin VB.CommandButton cmdOpen 
         Caption         =   "click here to open a file..."
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   4095
      End
   End
   Begin MSComDlg.CommonDialog cmd 
      Left            =   3960
      Top             =   960
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame frameMulti 
      Caption         =   " device 2 "
      Height          =   735
      Index           =   1
      Left            =   120
      TabIndex        =   2
      Top             =   720
      Width           =   4335
      Begin VB.CommandButton cmdOpen 
         Caption         =   "click here to open a file..."
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   3
         Top             =   240
         Width           =   4095
      End
   End
End
Attribute VB_Name = "frmMulti"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'//////////////////////////////////////////////////////////////////////
' frmMulti.frm - Copyright (c) 2003 JOBnik! [Arthur Aminov, ISRAEL]
'                                   e-mail: jobnik2k@hotmail.com
'
' Other sources: frmDevice.frm
'
' BASS Multiple output example
' Originally Translated from - multi.c - Example of Ian Luck
'//////////////////////////////////////////////////////////////////////
 
Option Explicit

Dim outdev(2) As Long   'output devices
Dim chan(2) As Long     'the streams

'Display error message
Sub Error_(ByVal Message As String)
    Call MsgBox(Message & vbCrLf & vbCrLf & "Error Code : " & BASS_ErrorGetCode, vbExclamation, "Error")
End Sub

Private Sub Form_Load()
    'change and set the current path
    'so VB won't ever tell you, that "bass.dll" isn't found
    ChDrive App.Path
    ChDir App.Path
    
    'check if "bass.dll" is exists
    If FileExists(RPP(App.Path) & "bass.dll") = False Then
        Call Error_("BASS.DLL does not exists")
        End
    End If
    
    'Check that BASS 2.0 was loaded
    If BASS_GetVersion <> MakeLong(2, 0) Then
        Call Error_("BASS version 2.0 was not loaded")
        End
    End If

    'Let the user choose the output devices
    With frmDevice
        .SelectDevice 1
        .Show vbModal, Me
        outdev(0) = .device
        .SelectDevice 2
        .Show vbModal, Me
        outdev(1) = .device
    End With

    'setup output devices
    If (BASS_Init(outdev(0), 44100, 0, Me.hWnd, 0) = 0) Then
        Call Error_("Can't initialize device 1")
        Unload Me
    End If
    
    If (BASS_Init(outdev(1), 44100, 0, Me.hWnd, 0) = 0) Then
        Call Error_("Can't initialize device 2")
        Unload Me
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    'release both devices
    Call BASS_SetDevice(outdev(0))
    Call BASS_Free
    Call BASS_SetDevice(outdev(1))
    Call BASS_Free
End Sub

Private Sub cmdOpen_Click(Index As Integer)
    On Error Resume Next    'if Cancel pressed...

    'open a file to play on selected device
    cmd.CancelError = True
    cmd.flags = cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly
    cmd.DialogTitle = "Open"
    cmd.Filter = "streamable files|*.mp3;*.mp2;*.mp1;*.ogg;*.wav|All files|*.*"
    cmd.ShowOpen

    'if cancel was pressed, exit the procedure
    If Err.Number = 32755 Then Exit Sub

    Call BASS_StreamFree(chan(Index))
    Call BASS_SetDevice(outdev(Index)) 'working with the selected device now...

    chan(Index) = BASS_StreamCreateFile(BASSFALSE, cmd.FileName, 0, 0, 0)

    'whatever it is, it ain't playable
    If (chan(Index) = 0) Then
        cmdOpen(Index).Caption = "click here to open a file..."
        Call Error_("Can't play the file")
        Exit Sub
    End If

    cmdOpen(Index).Caption = cmd.FileName
    Call BASS_StreamPlay(chan(Index), 0, BASS_SAMPLE_LOOP)
End Sub

'----------------------------------
' some useful function :)
'----------------------------------

'check if any file exists
Public Function FileExists(ByVal FileName As String) As Boolean
  On Local Error Resume Next
  FileExists = (Dir$(FileName) <> "")
End Function

' RPP = Return Proper Path
Function RPP(ByVal fp As String) As String
    RPP = IIf(Mid(fp, Len(fp), 1) <> "\", fp & "\", fp)
End Function
